# Quick Start Guide - Deployment ke cPanel

## File yang Sudah Dibuat

1. ✅ `app.json` - Konfigurasi untuk cPanel Node.js App
2. ✅ `start.js` - Startup script yang memastikan port benar
3. ✅ `.htaccess` - Routing rules untuk Apache
4. ✅ `DEPLOYMENT.md` - Panduan lengkap deployment

## Langkah Cepat (5 Menit)

### 1. Upload ke cPanel
Upload semua file ke folder aplikasi Anda (biasanya `public_html` atau subdomain folder).

### 2. Setup Node.js App di cPanel DULU ⚠️ PENTING!
**JANGAN install dependencies dulu!** Setup Node.js App dulu agar npm tersedia.

1. Buka **cPanel** → **Setup Node.js App**
2. Klik **Create Application**
3. Isi:
   - **Node.js version**: 18 atau lebih tinggi
   - **Application root**: `public_html` (atau folder aplikasi)
   - **Application URL**: Pilih domain/subdomain
   - **Application startup file**: `start.js` ⚠️ PENTING!
   - **Load App File**: `app.json`
4. Klik **Create**

### 3. Install Dependencies
**Sekarang npm sudah tersedia**, jalankan di Terminal cPanel:
```bash
cd ~/public_html  # atau path aplikasi Anda
npm install --production
```

**Note**: Jika masih error "npm: command not found", baca `FIX_NPM_NOT_FOUND.md`

### 4. Setup Environment Variables
1. Buka **cPanel** → **Setup Node.js App**
2. Klik **Create Application**
3. Isi:
   - **Node.js version**: 18 atau lebih tinggi
   - **Application root**: `public_html` (atau folder aplikasi)
   - **Application URL**: Pilih domain/subdomain
   - **Application startup file**: `start.js` ⚠️ PENTING!
   - **Load App File**: `app.json`

Di halaman edit aplikasi Node.js, tambahkan:
```
NODE_ENV=production
```

**Catatan**: `PORT` akan otomatis disediakan oleh cPanel, jangan set manual.

### 5. Restart App
Klik **Restart** pada aplikasi Node.js Anda.

## Troubleshooting Error 503

### ✅ Checklist

- [ ] Dependencies sudah terinstall (`npm install --production`)
- [ ] Node.js version minimal 18+
- [ ] Startup file di cPanel: `start.js` (BUKAN `dist/index.cjs`)
- [ ] Environment variable `NODE_ENV=production` sudah di-set
- [ ] Aplikasi sudah di-restart setelah perubahan
- [ ] Cek logs di cPanel untuk error details

### Cek Logs
Di cPanel: **Setup Node.js App** → Pilih aplikasi → **View Logs**

Atau di Terminal:
```bash
tail -f logs/err.log
tail -f logs/out.log
```

### Common Issues

**Issue**: "Cannot find module"
**Solution**: 
```bash
npm install --production
```

**Issue**: "Port already in use"
**Solution**: Restart aplikasi dari cPanel

**Issue**: "Application failed to start"
**Solution**: 
1. Cek logs untuk detail error
2. Pastikan `start.js` sebagai startup file
3. Pastikan semua dependencies terinstall

## Struktur File yang Benar

```
public_html/
├── dist/
│   ├── index.cjs
│   └── public/
├── node_modules/        # Setelah npm install
├── package.json
├── package-lock.json
├── app.json            # ✅ Baru
├── start.js            # ✅ Baru
├── .htaccess           # ✅ Baru
└── logs/               # Akan dibuat otomatis
```

## Support

Jika masih error 503 setelah mengikuti langkah di atas:
1. Cek logs error di cPanel
2. Screenshot error message
3. Cek apakah Node.js version sesuai
4. Pastikan semua file sudah terupload dengan benar

