#!/usr/bin/env node

/**
 * Startup script untuk cPanel deployment
 * Script ini memastikan PORT dari environment variable digunakan dengan benar
 */

// Set default environment
process.env.NODE_ENV = process.env.NODE_ENV || 'production';

// Log startup information
console.log('Starting La Chroma App...');
console.log('NODE_ENV:', process.env.NODE_ENV);
console.log('PORT:', process.env.PORT || 'not set (will use default)');
console.log('Working directory:', process.cwd());

// Import and start the application
try {
  require('./dist/index.cjs');
  console.log('Application started successfully');
} catch (error) {
  console.error('Error starting application:', error);
  process.exit(1);
}

